<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/helpers.php';

header('Content-Type: application/json; charset=utf-8');

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$action = $_GET['action'] ?? '';

try {
    ensure_schema($pdo);
} catch (Throwable $e) {
    // jeśli migracja się wywali, dalej próbujemy działać
}

try {
    // 1. Rejestracja konta mobilnego
    if ($action === 'register' && $method === 'POST') {
        $data = json_input();
        $prefix = (string)($data['phone_prefix'] ?? '');
        $phone = (string)($data['phone'] ?? '');
        $email = isset($data['email']) && $data['email'] !== '' ? (string)$data['email'] : null;
        $pass = (string)($data['password'] ?? '');
        $pass2 = (string)($data['password2'] ?? '');

        if ($prefix === '' || $phone === '' || $pass === '' || $pass2 === '') {
            http_response_code(400);
            echo json_encode(['error' => 'missing']);
            exit;
        }
        if ($pass !== $pass2) {
            http_response_code(400);
            echo json_encode(['error' => 'password_mismatch']);
            exit;
        }

        $res = register_mobile_user($pdo, $prefix, $phone, $email, $pass);
        if (isset($res['error'])) {
            http_response_code(400);
            echo json_encode(['error' => $res['error']]);
            exit;
        }

        echo json_encode(['ok' => true, 'user' => $res]);
        exit;
    }

    // 2. Logowanie
    if ($action === 'login' && $method === 'POST') {
        $data = json_input();
        $prefix = (string)($data['phone_prefix'] ?? '');
        $phone = (string)($data['phone'] ?? '');
        $pass = (string)($data['password'] ?? '');

        if ($prefix === '' || $phone === '' || $pass === '') {
            http_response_code(400);
            echo json_encode(['error' => 'missing']);
            exit;
        }

        $user = login_mobile_user($pdo, $prefix, $phone, $pass);
        if (!$user) {
            http_response_code(401);
            echo json_encode(['error' => 'invalid']);
            exit;
        }

        echo json_encode(['ok' => true, 'user' => $user]);
        exit;
    }

    // 3. Przypomnienie hasła (po emailu)
    if ($action === 'forgotPassword' && $method === 'POST') {
        $data = json_input();
        $email = (string)($data['email'] ?? '');
        if (trim($email) === '') {
            http_response_code(400);
            echo json_encode(['error' => 'missing_email']);
            exit;
        }

        $newPass = generate_reset_password($pdo, $email);
        if ($newPass === null) {
            // nie zdradzamy, czy konto istnieje
            echo json_encode(['ok' => true]);
            exit;
        }

        // W produkcji hasło powinno być wysłane mailem z głównego systemu.
        echo json_encode(['ok' => true]);
        exit;
    }

    // 4. Szczegóły zalogowanego użytkownika
    if ($action === 'me' && $method === 'GET') {
        $uid = require_mobile_auth($pdo);
        $stmt = $pdo->prepare("SELECT id, phone_prefix, phone_number, email, created_at FROM mobile_users WHERE id = ? LIMIT 1");
        $stmt->execute([$uid]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            http_response_code(401);
            echo json_encode(['error' => 'unauthorized']);
            exit;
        }
        $row['id'] = (int)$row['id'];
        echo json_encode(['ok' => true, 'user' => $row]);
        exit;
    }

    // 5. Lista plików przypisanych do zalogowanego konta
    if ($action === 'assignedFiles' && $method === 'GET') {
        $uid = require_mobile_auth($pdo);
        $items = list_assigned_files($pdo, $uid);
        echo json_encode(['ok' => true, 'items' => $items]);
        exit;
    }

    // 6. Wylogowanie
    if ($action === 'logout' && $method === 'POST') {
        session_destroy();
        echo json_encode(['ok' => true]);
        exit;
    }

    // 7. Rejestracja urządzenia serwerowego (przy pierwszym uruchomieniu) – bez autoryzacji
    if ($action === 'registerDevice' && $method === 'POST') {
        $data = json_input();
        $identifier = trim((string)($data['identifier'] ?? ''));
        $name = trim((string)($data['name'] ?? ''));

        if ($identifier === '' || $name === '') {
            http_response_code(400);
            echo json_encode(['error' => 'missing']);
            exit;
        }

        $res = register_device($pdo, $identifier, $name);
        if (isset($res['error'])) {
            http_response_code(400);
            echo json_encode(['error' => $res['error']]);
            exit;
        }

        echo json_encode(['ok' => true, 'device_id' => $res['device_id'], 'api_key' => $res['api_key']]);
        exit;
    }

    // 8. Endpoint dla urządzenia serwerowego – przypisanie pliku do numeru telefonu
    if ($action === 'assignFile' && $method === 'POST') {
        $deviceId = require_device_auth($pdo);
        $data = json_input();

        $prefix = (string)($data['phone_prefix'] ?? '');
        $phone = (string)($data['phone'] ?? '');
        $fileId = isset($data['file_id']) ? (int)$data['file_id'] : 0;
        $fileName = trim((string)($data['file_name'] ?? ''));
        $fileExt = isset($data['file_ext']) && $data['file_ext'] !== '' ? (string)$data['file_ext'] : null;

        if ($prefix === '' || $phone === '' || $fileId <= 0 || $fileName === '') {
            http_response_code(400);
            echo json_encode(['error' => 'missing']);
            exit;
        }

        $res = assign_file_to_phone($pdo, $deviceId, $prefix, $phone, $fileId, $fileName, $fileExt);
        if (isset($res['error'])) {
            if ($res['error'] === 'user_not_found') {
                http_response_code(404);
            } else {
                http_response_code(400);
            }
            echo json_encode(['error' => $res['error']]);
            exit;
        }

        echo json_encode(['ok' => true] + $res);
        exit;
    }

    http_response_code(404);
    echo json_encode(['error' => 'unknown_action']);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'exception',
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
    exit;
}

// Crafted with ❤️ by PixelShark.eu //

