<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);

// KONFIGURACJA BAZY PROXY
// Utwórz osobną bazę (np. allplayershare_proxy) i użytkownika
$dbHost = 'localhost';
$dbName = 'allplayershare_proxy';
$dbUser = 'allplayershare_proxy_user';
$dbPass = 'CHANGE_ME_PROXY_PASSWORD';

try {
    $pdo = new PDO(
        "mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4",
        $dbUser,
        $dbPass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]
    );
} catch (PDOException $e) {
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'DB connection failed', 'details' => $e->getMessage()]);
    exit;
}

function json_input(): array
{
    $raw = file_get_contents('php://input');
    if ($raw === false || $raw === '') {
        return [];
    }
    $data = json_decode($raw, true);
    return is_array($data) ? $data : [];
}

function random_token(int $length = 32): string
{
    return bin2hex(random_bytes($length));
}

function current_mobile_user_id(): ?int
{
    return isset($_SESSION['mobile_user_id']) ? (int)$_SESSION['mobile_user_id'] : null;
}

function require_mobile_auth(PDO $pdo): int
{
    $id = current_mobile_user_id();
    if (!$id) {
        http_response_code(401);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['error' => 'unauthorized']);
        exit;
    }

    // opcjonalnie można tu dorobić dodatkową weryfikację tokenu sesji
    return (int)$id;
}

function require_device_auth(PDO $pdo): int
{
    $apiKey = $_SERVER['HTTP_X_API_KEY'] ?? '';
    if ($apiKey === '') {
        http_response_code(401);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['error' => 'unauthorized_device']);
        exit;
    }

    $stmt = $pdo->prepare("SELECT id FROM devices WHERE api_key = ? LIMIT 1");
    $stmt->execute([$apiKey]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row) {
        http_response_code(401);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['error' => 'unauthorized_device']);
        exit;
    }
    return (int)$row['id'];
}

// Crafted with ❤️ by PixelShark.eu

